﻿/********************************************************************/
/*                                                                  */
/* ADOBE SYSTEMS INCORPORATED                                       */
/* Copyright 1986 - 2010 Adobe Systems Incorporated                 */
/* All Rights Reserved                                              */
/*                                                                  */
/* NOTICE:  Adobe permits you to use, modify, and distribute this   */
/* file in accordance with the terms of the Adobe license agreement */
/* accompanying it.  If you have received this file from a source   */
/* other than Adobe, then your use, modification, or distribution   */
/* of it requires the prior written permission of Adobe.            */
/*                                                                  */
/********************************************************************/
/*
* Program Name:                                                     
 *    EddUpdate.jsx- Update DITA 1.2 EDDs using menu command                                                    
 *                                                                   
 * General Description:                                              
 *    Automates the DITA 1.2 EDD update process
 *                                                                   
 *********************************************************************/    

EddUpdateMain();
	
function EddUpdateMain()
{
	var docMenu	 	=	app.GetNamedMenu("ditaFMtoolFileMenu");
	var bookMenu	=	app.GetNamedMenu("ditaFMtoolBookMenu");
	var ditamapMenu = 	app.GetNamedMenu("ditaFMtoolRMMenu");
	
	var cmd 		= 	DefineCommand(1, "Update Edds", "Update Edds...", "")            

	docMenu.AddCommandToMenu(cmd);
	bookMenu.AddCommandToMenu(cmd);
	ditamapMenu.AddCommandToMenu(cmd);

	UpdateMenus();     
}	

function Command(command)
{
     switch (command)
	{
		case 1:
			EddUpate();
			break;
	}
}

function EddUpate()
{	
	var files = [];
	
	var edd_folder = new Folder(app.HomeDir);
    edd_folder.changePath("structure/xml/DITA_1.2/app");
    var folder;
    if(edd_folder.exists)
    {   
        folder = edd_folder.selectDlg("Select EDD Folder");
    }  
    else
    {
        var base_folder = new Folder(app.HomeDir);
        folder =  base_folder.selectDlg("Select EDD Folder");
    }
	
	if(folder != null)
	{
        app.EddUpdateOn = true;
        
		var pvs = AllocatePropVals(1);
		pvs[0].propIdent.num = Constants.FP_DbTitleLabel;
		pvs[0].propVal.valType = Constants.FT_String;
		pvs[0].propVal.sval = "Please wait..." ;  
		
		ProgressBarEx(true, 0, pvs);  
		CreateAndUpdateBook(folder, "*.eddmod.fm", true);
		CreateAndUpdateBook(folder, "*.edd.fm", false);
		CloseAllFiles();

        app.EddUpdateOn = false;
		UpdateTemplates(folder);

        ProgressBarEx(false, 0);   
         
	}
} 

function UpdateTemplates(folder)
{
	var eddfiles = files;
	files = [];
	GetFiles(folder, "*.template.fm");
	var templatefiles = files;
	
	var i = 0;
	for(i = 0; i < templatefiles.length; i++)
	{
		var template = templatefiles[i];
		var template_name = template.name;
		var edd_name = template_name.replace(".template.fm", ".edd.fm")
		
		var j = 0;
		for(j = 0; j < eddfiles.length; j++)
		{
			var edd = eddfiles[j];
			if(edd.name.toLowerCase() == edd_name.toLowerCase())
			{
				ImportEdd(template.fsName, edd.fsName);
			}
		}
		
	}
}	

function ImportEdd(destination, source)
{
	var template = OpenFile(destination);
	var edd = OpenFile(source);
	
	template.SimpleImportElementDefs(edd, (Constants.FF_IED_REMOVE_OVERRIDES | Constants.FF_IED_REMOVE_BOOK_INFO | Constants.FF_IED_NO_NOTIFY));
	
	SaveFile(template, template.Name);
	template.Close(Constants.FF_CLOSE_MODIFIED);
	edd.Close(Constants.FF_CLOSE_MODIFIED);
}
	
function CreateAndUpdateBook(folder, matchstring, openfiles)
{	
	files = [];  
	GetFiles(folder, matchstring);  
	if (files.length > 0) {  
		
		var temp_file = Folder.temp;
		var i = 0;
		temp_file.changePath("temp" + i + ".book");
		
		while(temp_file.exists)
		{
			i++;
			temp_file = Folder.temp;
			temp_file.changePath("temp" + i + ".book");
		}
		
		var book = SilentNewBook();
		SaveFile(book, temp_file.fsName);
		book.Close(Constants.FF_CLOSE_MODIFIED);
		book = OpenBook(temp_file.fsName);

		var eloc = new ElementLoc (book.HighestLevelElement, book.HighestLevelElement.FirstChildElement, 0);

		var i = 0;  
		for (i = 0; i < files.length; i++) {  
			file = files[i];  
			book.NewBookComponentInHierarchy(file.fsName, eloc);
		}

        if(openfiles)
            OpenComponents(book);
		RunUpdateBook(book);	
		SaveFile(book, temp_file.fsName);
		SaveAllFiles();
        book.Close(Constants.FF_CLOSE_MODIFIED);
        temp_file.remove();
	}  
	else {  
		alert("Found no files with match string: " + matchstring);  
	} 
}

function GetFiles(theFolder, mask)
{  
	files  = files.concat (theFolder.getFiles(mask));
	var fileList = theFolder.getFiles();
	var i = 0;  
	for (i = 0; i < fileList.length; i++)
	{  
		file = fileList[i];  
		if (file instanceof Folder)
		{  
			GetFiles(file, mask);  
		}
	}
}  


function SaveFile(fmfile, name)  
{
    var params = GetSaveDefaultParams()
	var returnParamsp =new PropVals()

	fmfile.Save(name, params, returnParamsp);
	return;
}

function OpenBook(bookfile)
{
	var openProp = GetOpenDefaultParams()

	var i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FontChangedMetric)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FontNotFoundInCatalog)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_LanguageNotAvailable)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_LockCantBeReset)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_UpdateTextReferences)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_UpdateXRefs)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_UseAutoSaveFile)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_UseRecoverFile)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
	openProp[i].propVal.ival=false
	i=GetPropIndex(openProp,Constants.FS_BeefyDoc)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
	openProp[i].propVal.ival=Constants.FV_ResetLockAndContinue
	i=GetPropIndex(openProp,Constants.FS_BookIsInUse) 
	openProp[i].propVal.ival=Constants.FV_ResetLockAndContinue
	i=GetPropIndex(openProp,Constants.FS_MakeVisible)
	openProp[i].propVal.ival=true
	i=GetPropIndex(openProp,Constants.FS_RefFileNotFound)
	openProp[i].propVal.ival=Constants.FV_AllowAllRefFilesUnFindable
	i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FileIsStructured)
	openProp[i].propVal.ival=Constants.FV_OpenViewOnly
	i=GetPropIndex(openProp,Constants.FS_OpenFileNotWritable)
	openProp[i].propVal.ival=Constants.FV_DoOK

	var retParm = new PropVals()
	book = Open(bookfile, openProp, retParm); 
	return book;
}

function RunUpdateBook(book)
{
    var updateProp = GetUpdateBookDefaultParams();

	var i=GetPropIndex(updateProp,Constants.FS_UpdateBookGeneratedFiles);
	updateProp[i].propVal.ival=false;
	
    i=GetPropIndex(updateProp,Constants.FS_OpenOldVersionFiles);
	updateProp[i].propVal.ival=true;
	
	var retParm = new PropVals()
	
	book.UpdateBook(updateProp, retParm);
			   
}

function SaveAllFiles()
{
	var doc	= app.FirstOpenDoc
    while(doc.ObjectValid())
    {
        var doc2 = doc.NextOpenDocInSession;
        SaveFile(doc, doc.Name);
        doc = doc2;   
   }
}

function CloseAllFiles()
{
	var doc	= app.FirstOpenDoc
    while(doc.ObjectValid())
    {
        var doc2 = doc.NextOpenDocInSession;
        doc.Close(Constants.FF_CLOSE_MODIFIED);
        doc = doc2;   
   }
}

function OpenComponents(book)
{
	var comp = book.FirstComponentInBook;
    while(comp.ObjectValid())
    {
		OpenFile(comp.Name);
		var nextComp = comp.NextBookComponentInDFSOrder;
		comp=nextComp;
    } 
}


function OpenFile(filename)
{
	var openProp = GetOpenDefaultParams()

	var i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FontChangedMetric)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FontNotFoundInCatalog)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FontNotFoundInDoc)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_LanguageNotAvailable)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_LockCantBeReset)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_UpdateTextReferences)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_UpdateXRefs)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_UseAutoSaveFile)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_UseRecoverFile)
	openProp[i].propVal.ival=Constants.FV_DoNo
	i=GetPropIndex(openProp,Constants.FS_AlertUserAboutFailure)
	openProp[i].propVal.ival=false
	i=GetPropIndex(openProp,Constants.FS_BeefyDoc)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FileIsInUse) 
	openProp[i].propVal.ival=Constants.FV_ResetLockAndContinue
	i=GetPropIndex(openProp,Constants.FS_MakeVisible)
	openProp[i].propVal.ival=true
	i=GetPropIndex(openProp,Constants.FS_RefFileNotFound)
	openProp[i].propVal.ival=Constants.FV_AllowAllRefFilesUnFindable
	i=GetPropIndex(openProp,Constants.FS_FileIsOldVersion)
	openProp[i].propVal.ival=Constants.FV_DoOK
	i=GetPropIndex(openProp,Constants.FS_FileIsStructured)
	openProp[i].propVal.ival=Constants.FV_OpenViewOnly
	i=GetPropIndex(openProp,Constants.FS_OpenFileNotWritable)
	openProp[i].propVal.ival=Constants.FV_DoOK         

	var retParm = new PropVals()
	var doc = Open(filename,openProp,retParm);
	
	return doc;
}